# -*- coding: utf-8 -*-
{
    'name': 'LOX Backup',
    'version': '18.0.1.0.0',
    'category': 'Administration',
    'summary': 'Automated cold storage backups with LOX',
    'description': """
LOX Backup - Cold Storage Backups for Odoo
==========================================

This module provides automated backup functionality integrated with LOX Cold Backup Service.

Features:
---------
* Automated database backups
* Filestore backups
* Multiple backup schedules per component
* Integration with LOX cloud storage
* Backup history and restore functionality
* Malware scanning and integrity verification

Compatible with Odoo 18.0 and 19.0.

For more information, visit: https://backlox.com
    """,
    'author': 'LOX Backup',
    'website': 'https://backlox.com',
    'license': 'LGPL-3',
    'depends': [
        'base',
        'mail',
    ],
    'data': [
        'security/ir.model.access.csv',
        'wizards/lox_backup_wizard_views.xml',
        'wizards/lox_restore_wizard_views.xml',
        'views/res_config_settings_views.xml',
        'views/lox_backup_config_views.xml',
        'views/lox_backup_schedule_views.xml',
        'views/lox_backup_log_views.xml',
        'views/lox_backup_profile_views.xml',
        'views/lox_backup_menus.xml',
        'data/ir_cron_data.xml',
        'data/lox_backup_data.xml',
    ],
    'external_dependencies': {
        'python': ['requests'],
    },
    'installable': True,
    'application': True,
    'auto_install': False,
}
