<div class="lox-backup-admin">
    {* Header *}
    <div class="lox-header">
        <div class="lox-header-logo">
            <i class="icon-shield"></i>
            <div>
                <h1 class="lox-header-title">{l s='LOX Cold Backup' mod='loxbackup'}</h1>
                <p class="lox-header-subtitle">{l s='Backup History' mod='loxbackup'}</p>
            </div>
        </div>
        <div class="lox-header-nav">
            <a href="{$module_link}" class="btn">
                <i class="icon-dashboard"></i> {l s='Dashboard' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=backups" class="btn active">
                <i class="icon-list"></i> {l s='Backups' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=schedules" class="btn">
                <i class="icon-time"></i> {l s='Schedules' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=profiles" class="btn">
                <i class="icon-folder-open"></i> {l s='Profiles' mod='loxbackup'}
            </a>
        </div>
    </div>

    {* Alert Message *}
    <div id="lox-message" class="lox-alert" style="display:none;"></div>

    {* Actions Bar *}
    <div class="lox-card">
        <div class="lox-card-body" style="padding: 16px;">
            <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 12px;">
                <div style="display: flex; gap: 12px;">
                    <button type="button" class="lox-btn lox-btn-primary" id="lox-run-backup">
                        <i class="icon-download"></i> {l s='Create Full Backup' mod='loxbackup'}
                    </button>
                    <a href="{$module_link}&action=profiles" class="lox-btn lox-btn-outline">
                        <i class="icon-folder-open"></i> {l s='Custom Backup' mod='loxbackup'}
                    </a>
                </div>
                <button type="button" class="lox-btn lox-btn-outline" id="lox-refresh">
                    <i class="icon-refresh"></i> {l s='Refresh' mod='loxbackup'}
                </button>
            </div>
        </div>
    </div>

    {* Loading State *}
    <div id="lox-loading" class="lox-card">
        <div class="lox-card-body" style="padding: 60px; text-align: center;">
            <span class="lox-spinner" style="width: 40px; height: 40px; border-width: 3px;"></span>
            <p style="margin-top: 16px; color: var(--lox-gray-500);">{l s='Loading backups...' mod='loxbackup'}</p>
        </div>
    </div>

    {* Backups Table *}
    <div class="lox-card" id="lox-backups-card" style="display:none;">
        <div class="lox-card-header">
            <h3><i class="icon-list"></i> {l s='Backup History' mod='loxbackup'}</h3>
            <span id="lox-total-count" class="lox-badge"></span>
        </div>
        <div class="lox-card-body" style="padding: 0;">
            <table class="lox-table" id="lox-backups-table">
                <thead>
                    <tr>
                        <th>{l s='Name' mod='loxbackup'}</th>
                        <th>{l s='Component' mod='loxbackup'}</th>
                        <th>{l s='Size' mod='loxbackup'}</th>
                        <th>{l s='Status' mod='loxbackup'}</th>
                        <th>{l s='Created' mod='loxbackup'}</th>
                        <th>{l s='Actions' mod='loxbackup'}</th>
                    </tr>
                </thead>
                <tbody id="lox-backups-list">
                </tbody>
            </table>
        </div>
        <div class="lox-card-footer" id="lox-pagination" style="display:none;">
            <div style="display: flex; justify-content: center; align-items: center; gap: 16px;">
                <button class="lox-btn lox-btn-outline lox-btn-sm" id="lox-prev">
                    <i class="icon-chevron-left"></i> {l s='Previous' mod='loxbackup'}
                </button>
                <span id="lox-page-info" style="color: var(--lox-gray-600); font-size: 14px;"></span>
                <button class="lox-btn lox-btn-outline lox-btn-sm" id="lox-next">
                    {l s='Next' mod='loxbackup'} <i class="icon-chevron-right"></i>
                </button>
            </div>
        </div>
    </div>

    {* Empty State *}
    <div class="lox-card" id="lox-empty" style="display:none;">
        <div class="lox-empty-state">
            <i class="icon-cloud-download"></i>
            <h3>{l s='No backups yet' mod='loxbackup'}</h3>
            <p>{l s='Create your first backup to protect your store data.' mod='loxbackup'}</p>
            <button type="button" class="lox-btn lox-btn-primary" id="lox-run-backup-empty">
                <i class="icon-download"></i> {l s='Create First Backup' mod='loxbackup'}
            </button>
        </div>
    </div>

    {* Restore Confirmation Modal *}
    <div id="lox-restore-modal" class="lox-modal" style="display:none;">
        <div class="lox-modal-backdrop"></div>
        <div class="lox-modal-content lox-restore-modal-content">
            <div class="lox-modal-header lox-restore-modal-header">
                <div class="lox-restore-icon">
                    <i class="icon-exclamation-triangle"></i>
                </div>
                <h3>{l s='Confirm Restore' mod='loxbackup'}</h3>
                <button type="button" class="lox-modal-close">&times;</button>
            </div>
            <div class="lox-modal-body">
                <input type="hidden" id="restore-backup-uuid" value="">

                <div class="lox-restore-warning">
                    <p><strong>{l s='Warning: This action is irreversible!' mod='loxbackup'}</strong></p>
                    <p>{l s='This will overwrite your current store data. This action cannot be undone.' mod='loxbackup'}</p>
                </div>

                <div class="lox-restore-details">
                    <p><strong>{l s='Backup to restore:' mod='loxbackup'}</strong></p>
                    <div id="restore-backup-info" class="lox-backup-info-box">
                        <span class="backup-name"></span>
                        <span class="backup-date"></span>
                    </div>
                </div>

                <div class="lox-form-group lox-restore-confirm-group">
                    <label for="restore-confirmation-input">
                        {l s='To confirm, type' mod='loxbackup'} <strong>RESTORE</strong> {l s='below:' mod='loxbackup'}
                    </label>
                    <input type="text" id="restore-confirmation-input" class="form-control" placeholder="{l s='Type RESTORE to confirm' mod='loxbackup'}" autocomplete="off">
                    <p class="lox-error-message" id="restore-confirmation-error" style="display:none;">
                        {l s='Please type RESTORE to confirm' mod='loxbackup'}
                    </p>
                </div>
            </div>
            <div class="lox-modal-footer">
                <button type="button" class="lox-btn lox-btn-outline lox-modal-cancel">{l s='Cancel' mod='loxbackup'}</button>
                <button type="button" class="lox-btn lox-btn-danger" id="lox-confirm-restore" disabled>
                    <i class="icon-refresh"></i> {l s='Restore Backup' mod='loxbackup'}
                </button>
            </div>
        </div>
    </div>

    <style>
    .lox-modal {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 100000;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .lox-modal-backdrop {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
    }
    .lox-modal-content {
        position: relative;
        width: 90%;
        max-width: 480px;
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
    }
    .lox-restore-modal-header {
        display: flex;
        align-items: center;
        padding: 20px 24px;
        background: linear-gradient(135deg, #dc2626 0%, #ef4444 100%);
        color: #fff;
        border-radius: 12px 12px 0 0;
    }
    .lox-restore-modal-header h3 {
        margin: 0;
        flex: 1;
        color: #fff;
        font-size: 18px;
    }
    .lox-restore-icon {
        width: 48px;
        height: 48px;
        background: rgba(255,255,255,0.2);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-right: 12px;
    }
    .lox-restore-icon i {
        font-size: 24px;
    }
    .lox-modal-close {
        background: none;
        border: none;
        font-size: 28px;
        color: rgba(255,255,255,0.8);
        cursor: pointer;
        padding: 0;
        line-height: 1;
    }
    .lox-modal-close:hover {
        color: #fff;
    }
    .lox-modal-body {
        padding: 24px;
    }
    .lox-restore-warning {
        background: #fef2f2;
        border: 1px solid #fecaca;
        border-radius: 8px;
        padding: 16px;
        margin-bottom: 20px;
    }
    .lox-restore-warning p {
        margin: 0 0 8px 0;
        color: #991b1b;
    }
    .lox-restore-warning p:last-child {
        margin-bottom: 0;
    }
    .lox-restore-details {
        margin-bottom: 20px;
    }
    .lox-backup-info-box {
        background: #f3f4f6;
        border-radius: 8px;
        padding: 12px 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    .lox-backup-info-box .backup-name {
        font-weight: 600;
        color: #374151;
    }
    .lox-backup-info-box .backup-date {
        color: #6b7280;
        font-size: 13px;
    }
    .lox-restore-confirm-group label {
        display: block;
        margin-bottom: 8px;
        color: #374151;
    }
    .lox-restore-confirm-group input {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #d1d5db;
        border-radius: 8px;
        font-size: 16px;
        transition: border-color 0.2s;
    }
    .lox-restore-confirm-group input:focus {
        outline: none;
        border-color: #dc2626;
    }
    .lox-restore-confirm-group input.valid {
        border-color: #10b981;
        background: #f0fdf4;
    }
    .lox-error-message {
        color: #dc2626;
        font-size: 13px;
        margin-top: 8px;
    }
    .lox-modal-footer {
        display: flex;
        justify-content: flex-end;
        gap: 12px;
        padding: 16px 24px;
        border-top: 1px solid #e5e7eb;
        background: #f9fafb;
        border-radius: 0 0 12px 12px;
    }
    .lox-btn-danger {
        background: #dc2626 !important;
        border-color: #b91c1c !important;
        color: #fff !important;
    }
    .lox-btn-danger:hover:not(:disabled) {
        background: #b91c1c !important;
    }
    .lox-btn-danger:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    </style>
</div>

{* FORGE QA Widget *}
<script src="https://forge.argentica.ai/qa-widget.js" data-project="lox-prestashop" async></script>

<script>
var loxBackupConfig = {
    ajaxUrl: '{$ajax_url|escape:"javascript"}',
    texts: {
        download: '{l s="Download" mod="loxbackup" js=1}',
        restore: '{l s="Restore" mod="loxbackup" js=1}',
        backups: '{l s="backups" mod="loxbackup" js=1}',
        page: '{l s="Page" mod="loxbackup" js=1}',
        of: '{l s="of" mod="loxbackup" js=1}',
        failedToLoad: '{l s="Failed to load backups" mod="loxbackup" js=1}',
        downloadReady: '{l s="Download will be ready soon." mod="loxbackup" js=1}',
        confirmRestore: '{l s="Are you sure you want to restore this backup? This will overwrite current data." mod="loxbackup" js=1}',
        restoring: '{l s="Restoring backup, please wait..." mod="loxbackup" js=1}',
        running: '{l s="Running..." mod="loxbackup" js=1}',
        creatingBackup: '{l s="Creating full backup, please wait..." mod="loxbackup" js=1}'
    }
};
</script>
{literal}
<script>
$(document).ready(function() {
    var currentPage = 1;
    var totalPages = 1;
    var config = loxBackupConfig;

    function loadBackups(page) {
        page = page || 1;
        $('#lox-loading').show();
        $('#lox-backups-card, #lox-empty').hide();

        $.post(config.ajaxUrl + '&action=ajax_list', { page: page }, function(response) {
            $('#lox-loading').hide();

            if (response.success && response.data.items && response.data.items.length > 0) {
                var html = '';
                response.data.items.forEach(function(backup) {
                    var statusClass = backup.status === 'COMPLETED' ? 'success' :
                                     (backup.status === 'FAILED' ? 'danger' :
                                     (backup.status === 'IN_PROGRESS' ? 'warning' : 'default'));
                    var component = backup.component || 'full';
                    var componentClass = component.toLowerCase().replace(/[^a-z]/g, '');

                    html += '<tr data-uuid="' + backup.uuid + '">';
                    html += '<td><strong>' + escapeHtml(backup.name) + '</strong></td>';
                    html += '<td><span class="lox-component-tag ' + componentClass + '">' + escapeHtml(component) + '</span></td>';
                    html += '<td>' + formatBytes(backup.size_bytes) + '</td>';
                    html += '<td><span class="lox-status ' + statusClass + '">' + backup.status + '</span></td>';
                    html += '<td>' + formatDate(backup.created_at) + '</td>';
                    html += '<td>';
                    if (backup.status === 'COMPLETED') {
                        html += '<div style="display: flex; gap: 8px;">';
                        html += '<button class="lox-btn lox-btn-outline lox-btn-sm lox-download" data-uuid="' + backup.uuid + '">';
                        html += '<i class="icon-download"></i> ' + config.texts.download;
                        html += '</button>';
                        html += '<button class="lox-btn lox-btn-outline lox-btn-sm lox-restore" data-uuid="' + backup.uuid + '">';
                        html += '<i class="icon-refresh"></i> ' + config.texts.restore;
                        html += '</button>';
                        html += '</div>';
                    } else if (backup.status === 'IN_PROGRESS') {
                        html += '<span class="lox-spinner" style="width: 16px; height: 16px;"></span>';
                    }
                    html += '</td>';
                    html += '</tr>';
                });
                $('#lox-backups-list').html(html);
                $('#lox-total-count').text(response.data.total + ' ' + config.texts.backups);
                $('#lox-backups-card').show();

                currentPage = response.data.page;
                totalPages = Math.ceil(response.data.total / response.data.page_size);
                if (totalPages > 1) {
                    $('#lox-page-info').text(config.texts.page + ' ' + currentPage + ' ' + config.texts.of + ' ' + totalPages);
                    $('#lox-prev').prop('disabled', currentPage <= 1);
                    $('#lox-next').prop('disabled', currentPage >= totalPages);
                    $('#lox-pagination').show();
                } else {
                    $('#lox-pagination').hide();
                }
            } else {
                $('#lox-empty').show();
            }
        }, 'json').fail(function() {
            $('#lox-loading').hide();
            showMessage('error', config.texts.failedToLoad);
        });
    }

    function escapeHtml(text) {
        var div = document.createElement('div');
        div.appendChild(document.createTextNode(text));
        return div.innerHTML;
    }

    function formatBytes(bytes) {
        if (bytes === 0) return '0 B';
        var k = 1024;
        var sizes = ['B', 'KB', 'MB', 'GB'];
        var i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
    }

    function formatDate(dateStr) {
        var date = new Date(dateStr);
        var options = {hour: '2-digit', minute: '2-digit'};
        return date.toLocaleDateString() + ' ' + date.toLocaleTimeString([], options);
    }

    function showMessage(type, message) {
        var alertClass = 'lox-alert-' + type;
        $('#lox-message')
            .removeClass('lox-alert-success lox-alert-error lox-alert-warning lox-alert-info')
            .addClass(alertClass)
            .html(message)
            .show();

        if (type === 'success') {
            setTimeout(function() {
                $('#lox-message').fadeOut();
            }, 5000);
        }
    }

    loadBackups();

    $('#lox-refresh').on('click', function() {
        var $btn = $(this);
        $btn.find('i').addClass('icon-spin');
        loadBackups(currentPage);
        setTimeout(function() {
            $btn.find('i').removeClass('icon-spin');
        }, 500);
    });

    $('#lox-prev').on('click', function() { if (currentPage > 1) loadBackups(currentPage - 1); });
    $('#lox-next').on('click', function() { if (currentPage < totalPages) loadBackups(currentPage + 1); });

    $(document).on('click', '.lox-download', function() {
        var uuid = $(this).data('uuid');
        var $btn = $(this);
        var originalHtml = $btn.html();
        $btn.prop('disabled', true).html('<span class="lox-spinner" style="width:14px;height:14px;"></span>');

        $.post(config.ajaxUrl + '&action=ajax_download', { uuid: uuid }, function(response) {
            $btn.prop('disabled', false).html(originalHtml);
            if (response.success && response.download_url) {
                window.open(response.download_url, '_blank');
            } else {
                showMessage('warning', '<i class="icon-info-circle"></i> ' + (response.error || config.texts.downloadReady));
            }
        }, 'json');
    });

    // Restore button - open modal
    $(document).on('click', '.lox-restore', function() {
        var uuid = $(this).data('uuid');
        var $row = $(this).closest('tr');
        var backupName = $row.find('td:first strong').text();
        var backupDate = $row.find('td:eq(4)').text();

        // Set modal data
        $('#restore-backup-uuid').val(uuid);
        $('#restore-backup-info .backup-name').text(backupName);
        $('#restore-backup-info .backup-date').text(backupDate);
        $('#restore-confirmation-input').val('').removeClass('valid');
        $('#restore-confirmation-error').hide();
        $('#lox-confirm-restore').prop('disabled', true);

        // Show modal
        $('#lox-restore-modal').fadeIn(200);
        $('#restore-confirmation-input').focus();
    });

    // Validate confirmation input
    $('#restore-confirmation-input').on('input', function() {
        var value = $(this).val().toUpperCase().trim();
        var isValid = value === 'RESTORE';

        $(this).toggleClass('valid', isValid);
        $('#lox-confirm-restore').prop('disabled', !isValid);
        $('#restore-confirmation-error').toggle(value.length > 0 && !isValid);
    });

    // Close restore modal
    $('#lox-restore-modal .lox-modal-close, #lox-restore-modal .lox-modal-cancel, #lox-restore-modal .lox-modal-backdrop').on('click', function() {
        $('#lox-restore-modal').fadeOut(200);
    });

    // ESC key to close modal
    $(document).on('keydown', function(e) {
        if (e.key === 'Escape' && $('#lox-restore-modal').is(':visible')) {
            $('#lox-restore-modal').fadeOut(200);
        }
    });

    // Confirm restore
    $('#lox-confirm-restore').on('click', function() {
        var uuid = $('#restore-backup-uuid').val();
        var $btn = $(this);
        var originalHtml = $btn.html();

        $btn.prop('disabled', true).html('<span class="lox-spinner" style="width:14px;height:14px;"></span> ' + config.texts.restoring);

        $.post(config.ajaxUrl + '&action=ajax_restore', { uuid: uuid }, function(response) {
            $('#lox-restore-modal').fadeOut(200);
            if (response.success) {
                showMessage('success', '<i class="icon-check"></i> ' + response.message);
            } else {
                showMessage('error', '<i class="icon-times"></i> ' + response.error);
            }
        }, 'json').fail(function() {
            showMessage('error', '<i class="icon-times"></i> Restore request failed');
        }).always(function() {
            $btn.prop('disabled', false).html(originalHtml);
            $('#restore-confirmation-input').val('').removeClass('valid');
        });
    });

    function runBackup() {
        var $btn = $('#lox-run-backup');
        var originalHtml = $btn.html();
        $btn.prop('disabled', true).html('<span class="lox-spinner" style="width:14px;height:14px;"></span> ' + config.texts.running);

        showMessage('info', '<span class="lox-spinner" style="width:14px;height:14px;"></span> ' + config.texts.creatingBackup);

        $.post(config.ajaxUrl + '&action=ajax_backup', function(response) {
            $btn.prop('disabled', false).html(originalHtml);
            if (response.success) {
                showMessage('success', '<i class="icon-check"></i> ' + response.message);
                loadBackups();
            } else {
                showMessage('error', '<i class="icon-times"></i> ' + response.error);
            }
        }, 'json');
    }

    $('#lox-run-backup, #lox-run-backup-empty').on('click', runBackup);
});
</script>
{/literal}
