<div class="lox-backup-admin">
    {* Header *}
    <div class="lox-header">
        <div class="lox-header-logo">
            <i class="icon-shield"></i>
            <div>
                <h1 class="lox-header-title">{l s='LOX Cold Backup' mod='loxbackup'}</h1>
                <p class="lox-header-subtitle">{l s='Custom Backup Profiles' mod='loxbackup'}</p>
            </div>
        </div>
        <div class="lox-header-nav">
            <a href="{$module_link}" class="btn">
                <i class="icon-dashboard"></i> {l s='Dashboard' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=backups" class="btn">
                <i class="icon-list"></i> {l s='Backups' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=schedules" class="btn">
                <i class="icon-time"></i> {l s='Schedules' mod='loxbackup'}
            </a>
            <a href="{$module_link}&action=profiles" class="btn active">
                <i class="icon-folder-open"></i> {l s='Profiles' mod='loxbackup'}
            </a>
        </div>
    </div>

    {* Alert Message *}
    <div id="lox-message" class="lox-alert" style="display:none;"></div>

    {* Info Box *}
    <div class="lox-info-box">
        <i class="icon-info-circle"></i>
        <p>{l s='Create custom backup profiles that combine different elements. You can run them manually or schedule automatic backups.' mod='loxbackup'}</p>
    </div>

    {* Quick Custom Backup *}
    <div class="lox-card">
        <div class="lox-card-header">
            <h3><i class="icon-bolt"></i> {l s='Quick Custom Backup' mod='loxbackup'}</h3>
        </div>
        <div class="lox-card-body">
            <p style="margin-bottom: 20px; color: var(--lox-gray-600);">
                {l s='Select the elements you want to backup and run a one-time custom backup.' mod='loxbackup'}
            </p>

            <div class="lox-elements-grid" id="quick-backup-elements">
                {foreach from=$elements key=key item=element}
                <label class="lox-element-card">
                    <input type="checkbox" name="quick_elements[]" value="{$key}" {if $key == 'database'}checked{/if}>
                    <span class="lox-element-icon">
                        <i class="{$element.icon}"></i>
                    </span>
                    <span class="lox-element-info">
                        <strong>{$element.label|escape:'html':'UTF-8'}</strong>
                        <small>{$element.description|escape:'html':'UTF-8'}</small>
                    </span>
                    <span class="lox-element-check">
                        <i class="icon-check"></i>
                    </span>
                </label>
                {/foreach}
            </div>

            <div class="lox-quick-actions" style="border-top: none; padding-top: 0; margin-top: 0;">
                <button type="button" class="lox-btn lox-btn-primary" id="lox-run-quick-backup">
                    <i class="icon-download"></i> {l s='Run Custom Backup Now' mod='loxbackup'}
                </button>
            </div>
        </div>
    </div>

    {* Profile Tabs *}
    <div class="lox-tabs-wrapper">
        <div class="lox-tabs">
            <button type="button" class="lox-tab active" data-tab="remote">
                <i class="icon-cloud"></i> {l s='Cloud Profiles' mod='loxbackup'}
            </button>
            <button type="button" class="lox-tab" data-tab="local">
                <i class="icon-folder-open"></i> {l s='Local Profiles' mod='loxbackup'}
            </button>
        </div>
    </div>

    {* Remote Profiles Tab *}
    <div class="lox-tab-content active" id="lox-tab-remote">
        <div class="lox-card">
            <div class="lox-card-header">
                <h3><i class="icon-cloud"></i> {l s='Cloud Profiles (from LOX Server)' mod='loxbackup'}</h3>
                <button type="button" class="lox-btn lox-btn-outline lox-btn-sm" id="lox-refresh-remote-profiles">
                    <i class="icon-refresh"></i> {l s='Refresh' mod='loxbackup'}
                </button>
            </div>
            <div class="lox-card-body">
                <div id="lox-remote-profiles-loading" class="lox-loading-state">
                    <span class="lox-spinner"></span>
                    <p>{l s='Loading profiles from server...' mod='loxbackup'}</p>
                </div>
                <div id="lox-remote-profiles-empty" class="lox-empty-state" style="display:none;">
                    <i class="icon-cloud"></i>
                    <h3>{l s='No cloud profiles yet' mod='loxbackup'}</h3>
                    <p>{l s='Profiles are automatically created when you run backups. Each profile groups related backup versions.' mod='loxbackup'}</p>
                </div>
                <div id="lox-remote-profiles-grid" class="lox-profiles-grid" style="display:none;"></div>
            </div>
        </div>
    </div>

    {* Local Profiles Tab *}
    <div class="lox-tab-content" id="lox-tab-local" style="display:none;">
        <div class="lox-card">
            <div class="lox-card-header">
                <h3><i class="icon-folder-open"></i> {l s='Local Profiles' mod='loxbackup'}</h3>
                <button type="button" class="lox-btn lox-btn-primary lox-btn-sm" id="lox-add-profile">
                    <i class="icon-plus"></i> {l s='Add Profile' mod='loxbackup'}
                </button>
            </div>
            <div class="lox-card-body">
            {if empty($profiles)}
            <div class="lox-empty-state">
                <i class="icon-folder-open"></i>
                <h3>{l s='No profiles yet' mod='loxbackup'}</h3>
                <p>{l s='Create your first backup profile to save custom element combinations.' mod='loxbackup'}</p>
            </div>
            {else}
            <table class="lox-table" id="lox-profiles-table">
                <thead>
                    <tr>
                        <th>{l s='Profile Name' mod='loxbackup'}</th>
                        <th>{l s='Elements' mod='loxbackup'}</th>
                        <th>{l s='Schedule' mod='loxbackup'}</th>
                        <th>{l s='Last Run' mod='loxbackup'}</th>
                        <th>{l s='Actions' mod='loxbackup'}</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach from=$profiles key=id item=profile}
                    <tr data-profile-id="{$id|escape:'html':'UTF-8'}">
                        <td><strong>{$profile.name|escape:'html':'UTF-8'}</strong></td>
                        <td>
                            {foreach from=$profile.elements item=elem}
                                {if isset($elements[$elem])}
                                <span class="lox-component-tag {$elem}">
                                    <i class="{$elements[$elem].icon}"></i>
                                    {$elements[$elem].label|escape:'html':'UTF-8'}
                                </span>
                                {/if}
                            {/foreach}
                        </td>
                        <td>
                            {if $profile.schedule && $profile.schedule != 'disabled'}
                                <span class="lox-schedule-badge active">{$frequencies[$profile.schedule]|escape:'html':'UTF-8'}</span>
                            {else}
                                <span class="lox-schedule-badge disabled">{l s='Disabled' mod='loxbackup'}</span>
                            {/if}
                        </td>
                        <td>
                            {if $profile.last_run}
                                {$profile.last_run|escape:'html':'UTF-8'}
                                {if $profile.last_status}
                                    <br><span class="lox-status {$profile.last_status|lower}">{$profile.last_status|escape:'html':'UTF-8'}</span>
                                {/if}
                            {else}
                                <span style="color: var(--lox-gray-400);">{l s='Never' mod='loxbackup'}</span>
                            {/if}
                        </td>
                        <td>
                            <div style="display: flex; gap: 8px;">
                                <button class="lox-btn lox-btn-success lox-btn-sm lox-run-profile-btn" data-profile-id="{$id|escape:'html':'UTF-8'}">
                                    <i class="icon-play"></i> {l s='Run' mod='loxbackup'}
                                </button>
                                <button class="lox-btn lox-btn-outline lox-btn-sm lox-btn-icon lox-edit-profile-btn" data-profile-id="{$id|escape:'html':'UTF-8'}">
                                    <i class="icon-pencil"></i>
                                </button>
                                <button class="lox-btn lox-btn-outline lox-btn-sm lox-btn-icon lox-delete-profile-btn" data-profile-id="{$id|escape:'html':'UTF-8'}">
                                    <i class="icon-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    {/foreach}
                </tbody>
            </table>
            {/if}
            </div>
        </div>
    </div>
</div>

{* Profile Modal *}
<div id="lox-profile-modal" class="lox-modal" style="display:none;">
    <div class="lox-modal-backdrop"></div>
    <div class="lox-modal-content">
        <div class="lox-modal-header">
            <h3 id="lox-modal-title">{l s='Create Profile' mod='loxbackup'}</h3>
            <button type="button" class="lox-modal-close">&times;</button>
        </div>
        <div class="lox-modal-body">
            <input type="hidden" id="profile-id" value="">

            <div class="lox-form-group">
                <label for="profile-name">{l s='Profile Name' mod='loxbackup'}</label>
                <input type="text" id="profile-name" placeholder="{l s='e.g., Daily Database Backup' mod='loxbackup'}">
            </div>

            <div class="lox-form-group">
                <label>{l s='Elements to Backup' mod='loxbackup'}</label>
                <div class="lox-elements-grid" id="profile-elements">
                    {foreach from=$elements key=key item=element}
                    <label class="lox-element-card">
                        <input type="checkbox" name="profile_elements[]" value="{$key}">
                        <span class="lox-element-icon">
                            <i class="{$element.icon}"></i>
                        </span>
                        <span class="lox-element-info">
                            <strong>{$element.label|escape:'html':'UTF-8'}</strong>
                            <small>{$element.description|escape:'html':'UTF-8'}</small>
                        </span>
                        <span class="lox-element-check">
                            <i class="icon-check"></i>
                        </span>
                    </label>
                    {/foreach}
                </div>
            </div>

            <div class="lox-form-row">
                <div class="lox-form-group">
                    <label for="profile-schedule">{l s='Schedule' mod='loxbackup'}</label>
                    <select id="profile-schedule">
                        {foreach from=$frequencies key=key item=label}
                        <option value="{$key|escape:'html':'UTF-8'}">{$label|escape:'html':'UTF-8'}</option>
                        {/foreach}
                    </select>
                </div>
                <div class="lox-form-group">
                    <label for="profile-time">{l s='Time' mod='loxbackup'}</label>
                    <input type="time" id="profile-time" value="03:00">
                </div>
            </div>

            <div class="lox-form-row">
                <div class="lox-form-group">
                    <label for="profile-retention">{l s='Retention Days' mod='loxbackup'}</label>
                    <input type="number" id="profile-retention" min="1" max="3650" placeholder="{l s='Use default' mod='loxbackup'}">
                    <small class="lox-form-help">{l s='Leave empty to use frequency-based default' mod='loxbackup'}</small>
                </div>
                <div class="lox-form-group">
                    <label for="profile-immutable">{l s='Immutable Days' mod='loxbackup'}</label>
                    <input type="number" id="profile-immutable" min="0" max="3650" placeholder="{l s='Use default' mod='loxbackup'}">
                    <small class="lox-form-help">{l s='Anti-ransomware protection. 0 = allow deletion' mod='loxbackup'}</small>
                </div>
            </div>
        </div>
        <div class="lox-modal-footer">
            <button type="button" class="lox-btn lox-btn-outline lox-modal-cancel">{l s='Cancel' mod='loxbackup'}</button>
            <button type="button" class="lox-btn lox-btn-primary" id="lox-save-profile">
                <i class="icon-save"></i> {l s='Save Profile' mod='loxbackup'}
            </button>
        </div>
    </div>
</div>

{* FORGE QA Widget *}
<script src="https://forge.argentica.ai/qa-widget.js" data-project="lox-prestashop" async></script>

<script>
$(document).ready(function() {
    var profiles = {$profiles|json_encode};
    var elements = {$elements|json_encode};
    var remoteProfiles = [];

    // Tab switching
    $('.lox-tab').on('click', function() {
        var tab = $(this).data('tab');
        $('.lox-tab').removeClass('active');
        $(this).addClass('active');
        $('.lox-tab-content').hide();
        $('#lox-tab-' + tab).show();

        if (tab === 'remote' && remoteProfiles.length === 0) {
            loadRemoteProfiles();
        }
    });

    // Load remote profiles on init
    loadRemoteProfiles();

    function loadRemoteProfiles() {
        $('#lox-remote-profiles-loading').show();
        $('#lox-remote-profiles-empty').hide();
        $('#lox-remote-profiles-grid').hide();

        $.get('{$ajax_url}&action=ajax_get_remote_profiles', function(response) {
            $('#lox-remote-profiles-loading').hide();

            if (response.success && response.profiles && response.profiles.length > 0) {
                remoteProfiles = response.profiles;
                renderRemoteProfiles(response.profiles);
            } else {
                $('#lox-remote-profiles-empty').show();
            }
        }, 'json').fail(function() {
            $('#lox-remote-profiles-loading').hide();
            $('#lox-remote-profiles-empty').show();
        });
    }

    function renderRemoteProfiles(profiles) {
        var html = '';
        profiles.forEach(function(profile) {
            var lastBackup = profile.last_backup_at ? formatDate(profile.last_backup_at) : '{l s="Never" mod="loxbackup"}';
            var sizeFormatted = profile.total_size_bytes ? formatBytes(profile.total_size_bytes) : '--';

            html += '<div class="lox-profile-card" data-uuid="' + profile.uuid + '">';
            html += '  <div class="lox-profile-header">';
            html += '    <div class="lox-profile-icon"><i class="icon-archive"></i></div>';
            html += '    <div class="lox-profile-info">';
            html += '      <h4>' + escapeHtml(profile.name) + '</h4>';
            html += '      <span class="lox-profile-meta">' + profile.backup_count + ' {l s="versions" mod="loxbackup"} &bull; ' + sizeFormatted + '</span>';
            html += '    </div>';
            html += '  </div>';
            html += '  <div class="lox-profile-body">';
            html += '    <div class="lox-profile-stat">';
            html += '      <span class="lox-stat-label">{l s="Source" mod="loxbackup"}</span>';
            html += '      <span class="lox-stat-value">' + (profile.source || 'prestashop') + '</span>';
            html += '    </div>';
            html += '    <div class="lox-profile-stat">';
            html += '      <span class="lox-stat-label">{l s="Last Backup" mod="loxbackup"}</span>';
            html += '      <span class="lox-stat-value">' + lastBackup + '</span>';
            html += '    </div>';
            html += '  </div>';
            html += '  <div class="lox-profile-actions">';
            html += '    <button class="lox-btn lox-btn-outline lox-btn-sm lox-view-versions-btn" data-uuid="' + profile.uuid + '" data-name="' + escapeHtml(profile.name) + '">';
            html += '      <i class="icon-list"></i> {l s="Versions" mod="loxbackup"}';
            html += '    </button>';
            html += '    <button class="lox-btn lox-btn-success lox-btn-sm lox-run-remote-profile-btn" data-uuid="' + profile.uuid + '" data-name="' + escapeHtml(profile.name) + '">';
            html += '      <i class="icon-play"></i> {l s="Run" mod="loxbackup"}';
            html += '    </button>';
            html += '  </div>';
            html += '</div>';
        });

        $('#lox-remote-profiles-grid').html(html).show();
    }

    // Refresh remote profiles
    $('#lox-refresh-remote-profiles').on('click', function() {
        var $btn = $(this);
        $btn.find('i').addClass('icon-spin');
        loadRemoteProfiles();
        setTimeout(function() { $btn.find('i').removeClass('icon-spin'); }, 1000);
    });

    // View profile versions
    $(document).on('click', '.lox-view-versions-btn', function() {
        var uuid = $(this).data('uuid');
        var name = $(this).data('name');
        // For now, redirect to backups list filtered by profile
        showMessage('info', '{l s="Loading versions for" mod="loxbackup"} ' + name + '...');
        // Could open a modal here to show versions
    });

    // Run remote profile backup
    $(document).on('click', '.lox-run-remote-profile-btn', function() {
        var $btn = $(this);
        var profileUuid = $btn.data('uuid');
        var profileName = $btn.data('name');
        var originalHtml = $btn.html();

        // Get selected elements from quick backup (default to database if none)
        var selectedElements = [];
        $('#quick-backup-elements input:checked').each(function() {
            selectedElements.push($(this).val());
        });
        if (selectedElements.length === 0) {
            selectedElements = ['database'];
        }

        $btn.prop('disabled', true).html('<span class="lox-spinner"></span>');
        showMessage('info', '<span class="lox-spinner"></span> {l s="Running profile backup..." mod="loxbackup"}');

        $.post('{$ajax_url}&action=ajax_run_remote_profile', {
            profile_uuid: profileUuid,
            profile_name: profileName,
            elements: selectedElements
        }, function(response) {
            if (response.success) {
                showMessage('success', '<i class="icon-check"></i> {l s="Profile backup completed!" mod="loxbackup"} UUID: ' + response.uuid);
                setTimeout(loadRemoteProfiles, 2000);
            } else {
                showMessage('error', '<i class="icon-times"></i> ' + response.error);
            }
        }, 'json').fail(function() {
            showMessage('error', '<i class="icon-times"></i> {l s="Backup failed" mod="loxbackup"}');
        }).always(function() {
            $btn.prop('disabled', false).html(originalHtml);
        });
    });

    function formatBytes(bytes) {
        if (bytes === 0) return '0 B';
        var k = 1024;
        var sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
        var i = Math.floor(Math.log(bytes) / Math.log(k));
        return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
    }

    function formatDate(dateStr) {
        var d = new Date(dateStr);
        return d.toLocaleDateString() + ' ' + d.toLocaleTimeString();
    }

    function escapeHtml(str) {
        if (!str) return '';
        return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
    }

    // Quick custom backup
    $('#lox-run-quick-backup').on('click', function() {
        var $btn = $(this);
        var selectedElements = [];
        $('#quick-backup-elements input:checked').each(function() {
            selectedElements.push($(this).val());
        });

        if (selectedElements.length === 0) {
            showMessage('error', '{l s='Please select at least one element to backup' mod='loxbackup'}');
            return;
        }

        var originalHtml = $btn.html();
        $btn.prop('disabled', true).html('<span class="lox-spinner"></span> {l s='Running backup...' mod='loxbackup'}');

        showMessage('info', '<span class="lox-spinner"></span> {l s='Custom backup in progress. Please do not close this page.' mod='loxbackup'}');

        $.post('{$ajax_url}&action=ajax_custom_backup', {
            elements: selectedElements
        }, function(response) {
            if (response.success) {
                showMessage('success', '<i class="icon-check"></i> {l s='Custom backup completed!' mod='loxbackup'} UUID: ' + response.uuid);
            } else {
                showMessage('error', '<i class="icon-times"></i> ' + response.error);
            }
        }, 'json').fail(function() {
            showMessage('error', '<i class="icon-times"></i> {l s='Backup failed' mod='loxbackup'}');
        }).always(function() {
            $btn.prop('disabled', false).html(originalHtml);
        });
    });

    // Open modal for new profile
    $('#lox-add-profile').on('click', function() {
        $('#lox-modal-title').text('{l s='Create Profile' mod='loxbackup'}');
        $('#profile-id').val('');
        $('#profile-name').val('');
        $('#profile-elements input').prop('checked', false);
        $('#profile-schedule').val('disabled');
        $('#profile-time').val('03:00');
        $('#profile-retention').val('');
        $('#profile-immutable').val('');
        $('#lox-profile-modal').fadeIn(200);
    });

    // Edit profile
    $(document).on('click', '.lox-edit-profile-btn', function() {
        var profileId = $(this).data('profile-id');
        var profile = profiles[profileId];

        if (!profile) return;

        $('#lox-modal-title').text('{l s='Edit Profile' mod='loxbackup'}');
        $('#profile-id').val(profileId);
        $('#profile-name').val(profile.name);
        $('#profile-elements input').prop('checked', false);
        profile.elements.forEach(function(elem) {
            $('#profile-elements input[value="' + elem + '"]').prop('checked', true);
        });
        $('#profile-schedule').val(profile.schedule || 'disabled');
        $('#profile-time').val(profile.time || '03:00');
        $('#profile-retention').val(profile.retention_days || '');
        $('#profile-immutable').val(profile.immutable_days !== undefined && profile.immutable_days !== null ? profile.immutable_days : '');
        $('#lox-profile-modal').fadeIn(200);
    });

    // Close modal
    $('.lox-modal-close, .lox-modal-cancel, .lox-modal-backdrop').on('click', function() {
        $('#lox-profile-modal').fadeOut(200);
    });

    // Save profile
    $('#lox-save-profile').on('click', function() {
        var $btn = $(this);
        var profileId = $('#profile-id').val();
        var name = $('#profile-name').val().trim();
        var selectedElements = [];
        $('#profile-elements input:checked').each(function() {
            selectedElements.push($(this).val());
        });
        var schedule = $('#profile-schedule').val();
        var time = $('#profile-time').val();
        var retention = $('#profile-retention').val();
        var immutable = $('#profile-immutable').val();

        if (!name) {
            alert('{l s='Please enter a profile name' mod='loxbackup'}');
            return;
        }

        if (selectedElements.length === 0) {
            alert('{l s='Please select at least one element' mod='loxbackup'}');
            return;
        }

        $btn.prop('disabled', true);

        $.post('{$ajax_url}&action=ajax_save_profile', {
            profile_id: profileId,
            name: name,
            elements: selectedElements,
            schedule: schedule,
            time: time,
            retention_days: retention,
            immutable_days: immutable
        }, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert(response.error);
                $btn.prop('disabled', false);
            }
        }, 'json');
    });

    // Run profile
    $(document).on('click', '.lox-run-profile-btn', function() {
        var $btn = $(this);
        var profileId = $btn.data('profile-id');
        var originalHtml = $btn.html();

        $btn.prop('disabled', true).html('<span class="lox-spinner"></span>');
        showMessage('info', '<span class="lox-spinner"></span> {l s='Running profile backup...' mod='loxbackup'}');

        $.post('{$ajax_url}&action=ajax_run_profile', {
            profile_id: profileId
        }, function(response) {
            if (response.success) {
                showMessage('success', '<i class="icon-check"></i> {l s='Profile backup completed!' mod='loxbackup'} UUID: ' + response.uuid);
                setTimeout(function() { location.reload(); }, 2000);
            } else {
                showMessage('error', '<i class="icon-times"></i> ' + response.error);
            }
        }, 'json').fail(function() {
            showMessage('error', '<i class="icon-times"></i> {l s='Backup failed' mod='loxbackup'}');
        }).always(function() {
            $btn.prop('disabled', false).html(originalHtml);
        });
    });

    // Delete profile
    $(document).on('click', '.lox-delete-profile-btn', function() {
        if (!confirm('{l s='Are you sure you want to delete this profile?' mod='loxbackup'}')) {
            return;
        }

        var $btn = $(this);
        var profileId = $btn.data('profile-id');

        $.post('{$ajax_url}&action=ajax_delete_profile', {
            profile_id: profileId
        }, function(response) {
            if (response.success) {
                $btn.closest('tr').fadeOut(300, function() {
                    $(this).remove();
                });
            } else {
                alert(response.error);
            }
        }, 'json');
    });

    function showMessage(type, message) {
        var alertClass = 'lox-alert-' + type;
        $('#lox-message')
            .removeClass('lox-alert-success lox-alert-error lox-alert-warning lox-alert-info')
            .addClass(alertClass)
            .html(message)
            .show();
    }
});
</script>
